/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class ClassList {
    private static final String TRACE_MASKT = "XFRMCLTT";
    private static final String TRACE_MASKF = "XFRMCLTF";
    private static final String TRACE_MASKD = "XFRMCLTD";
    protected List classInfo;

    public ClassList(String file) throws IOException {
        this.classInfo = ClassList.getClassInfo(file);
    }

    public List getClassInfo() {
        return this.classInfo;
    }

    public List getClasses() throws ClassNotFoundException {
        return ClassList.getClassesFromNames(this.getClassNames());
    }

    public List getInstances() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return ClassList.getInstancesFromNames(this.getClassNames());
    }

    public static List getClassInfo(String file) throws IOException {
        ArrayList<Info> names = new ArrayList<Info>();
        Trace.trace(TRACE_MASKT, "-> ClassList.getClassInfo() static; using file [" + file + "]");
        BufferedReader in = new BufferedReader(new FileReader(file));
        String line = null;
        do {
            StringTokenizer tokenizer;
            if ((line = in.readLine()) == null || (line = line.trim()).length() <= 0 || line.substring(0, 1).equals("#") || line.substring(0, 1).equals("*") || !(tokenizer = new StringTokenizer(line)).hasMoreTokens()) continue;
            String className = tokenizer.nextToken();
            String synchronous = "false";
            if (tokenizer.hasMoreTokens()) {
                synchronous = tokenizer.nextToken();
            }
            Info info = new Info(className, synchronous.equalsIgnoreCase("true"));
            names.add(info);
            Trace.trace(TRACE_MASKF, "found class name [" + line + "].");
        } while (line != null);
        Trace.trace(TRACE_MASKT, "<- ClassList.getClassInfo() static()");
        return names;
    }

    public List getClassNames() {
        ArrayList<String> classNames = new ArrayList<String>(this.classInfo.size());
        Iterator iterator = this.classInfo.iterator();
        while (iterator.hasNext()) {
            classNames.add(((Info)iterator.next()).getClassName());
        }
        return classNames;
    }

    public static List getClasses(String file) throws IOException, ClassNotFoundException {
        Trace.trace(TRACE_MASKF, "-> ClassList.getClasses() static; using file [" + file + "]");
        ClassList classList = new ClassList(file);
        List classes = ClassList.getClassesFromNames(classList.getClassNames());
        Trace.trace(TRACE_MASKF, "<- ClassList.getClasses() static");
        return classes;
    }

    public static List getInstances(String file) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Trace.trace(TRACE_MASKF, "-> ClassList.getInstances() static; using file [" + file + "]");
        ClassList classList = new ClassList(file);
        List instances = ClassList.getInstancesFromNames(classList.getClassNames());
        Trace.trace(TRACE_MASKF, "<- ClassList.getInstances() static");
        return instances;
    }

    public static List getClassesFromNames(List names) throws ClassNotFoundException {
        Trace.trace(TRACE_MASKF, "-> ClassList.getClassesFromNames()");
        ArrayList classes = new ArrayList();
        int size = names.size();
        int i = 0;
        while (i < size) {
            String name = (String)names.get(i);
            Trace.trace(TRACE_MASKF, "Getting class [" + name + "].");
            classes.add(Class.forName(name));
            ++i;
        }
        Trace.trace(TRACE_MASKF, "<- ClassList.getClassesFromNames()");
        return classes;
    }

    public static List getInstancesFromNames(List names) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Trace.trace(TRACE_MASKF, "-> ClassList.getInstancesFromNames()");
        List classes = ClassList.getClassesFromNames(names);
        ArrayList instances = new ArrayList();
        int size = classes.size();
        int i = 0;
        while (i < size) {
            Class cls = (Class)classes.get(i);
            Trace.trace(TRACE_MASKF, "Getting instance for class [" + cls.getName() + "].");
            instances.add(cls.newInstance());
            ++i;
        }
        Trace.trace(TRACE_MASKF, "<- ClassList.getInstancesFromNames()");
        return instances;
    }

    public static class Info {
        private String className;
        private boolean synchronous;

        public Info(String className, boolean synchronous) {
            this.className = className;
            this.synchronous = synchronous;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean isSynchronous() {
            return this.synchronous;
        }
    }
}

